package editor;

import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public abstract class MobileScreenObject extends ScreenObject {

	
	private MobileScreenPaletteObject paletteObject;
	
	private int min;
	private int max;
	
	private int speed;
	
	private boolean goingMinDirection = false;
	
	private boolean isVertical;

	public int getMin() {
		return min;
	}

	public void setMin(int min) {
		this.min = min;
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}

	public int getSpeed() {
		return speed;
	}

	public void setSpeed(int speed) {
		this.speed = speed;
	}

	public boolean isVertical() {
		return isVertical;
	}

	public void setVertical(boolean isVertical) {
		this.isVertical = isVertical;
	}
	

	public void move(int xMove, int yMove) {
		
		if(this.getClickRect() != null)
			this.getClickRect().move(xMove, yMove);
		
		if(isVertical()) {
			this.setMin(this.getMin() + yMove);
			this.setMax(this.getMax() + yMove);
		} else {
			this.setMin(this.getMin() + xMove);
			this.setMax(this.getMax() + xMove);
		}
		
		
	}

	public MobileScreenPaletteObject getPaletteObject() {
		return paletteObject;
	}

	public void setPaletteObject(MobileScreenPaletteObject paletteObject) {
		this.paletteObject = paletteObject;
	}
	
	
	public void drawInitialDirIndicator(Graphics g) {
		
		
		Color origCol = g.getColor();
		
		g.setColor(Color.red);
		
		IntRect objRect = this.getClickRect();
		Point center = objRect.getCenter();
		
		g.drawOval(center.x - 10, center.y - 10, 21, 21);
		
		
		
		if(this.isVertical) {
			
			if(this.goingMinDirection) {
				//up
				
				g.drawLine(center.x, center.y + 5, center.x, center.y - 26);
				g.drawLine(center.x - 10, center.y - 15, center.x, center.y - 25);
				g.drawLine(center.x + 10, center.y - 15, center.x, center.y - 25);
				
				center.x += 1;
				g.drawLine(center.x, center.y + 5, center.x, center.y - 25);
				g.drawLine(center.x - 10, center.y - 15, center.x, center.y - 25);
				g.drawLine(center.x + 10, center.y - 15, center.x, center.y - 25);
				
				center.x -= 2;
				g.drawLine(center.x, center.y + 5, center.x, center.y - 25);
				g.drawLine(center.x - 10, center.y - 15, center.x, center.y - 25);
				g.drawLine(center.x + 10, center.y - 15, center.x, center.y - 25);
				
				center.x += 1;
				
			} else {
				//down
				
				g.drawLine(center.x, center.y + 5, center.x, center.y + 26);
				g.drawLine(center.x - 10, center.y + 15, center.x, center.y + 25);
				g.drawLine(center.x + 10, center.y + 15, center.x, center.y + 25);
				
				center.x += 1;
				g.drawLine(center.x, center.y + 5, center.x, center.y + 25);
				g.drawLine(center.x - 10, center.y + 15, center.x, center.y + 25);
				g.drawLine(center.x + 10, center.y + 15, center.x, center.y + 25);
				
				center.x -= 2;
				g.drawLine(center.x, center.y + 5, center.x, center.y + 25);
				g.drawLine(center.x - 10, center.y + 15, center.x, center.y + 25);
				g.drawLine(center.x + 10, center.y + 15, center.x, center.y + 25);
				
				center.x += 1;
				
			}
			
		} else {
			
			if(this.goingMinDirection) {
				//left
				
				g.drawLine(center.x - 5, center.y, center.x - 26, center.y);
				g.drawLine(center.x - 15, center.y - 10, center.x - 25, center.y);
				g.drawLine(center.x - 15, center.y + 10, center.x - 25, center.y);
				
				center.y += 1;
				g.drawLine(center.x - 5, center.y, center.x - 25, center.y);
				g.drawLine(center.x - 15, center.y - 10, center.x - 25, center.y);
				g.drawLine(center.x - 15, center.y + 10, center.x - 25, center.y);
				
				center.y -= 2;
				g.drawLine(center.x - 5, center.y, center.x - 25, center.y);
				g.drawLine(center.x - 15, center.y - 10, center.x - 25, center.y);
				g.drawLine(center.x - 15, center.y + 10, center.x - 25, center.y);
				
				center.y += 1;
				
			} else {
				//right
				
				g.drawLine(center.x + 5, center.y, center.x + 26, center.y);
				g.drawLine(center.x + 15, center.y - 10, center.x + 25, center.y);
				g.drawLine(center.x + 15, center.y + 10, center.x + 25, center.y);
				
				center.y += 1;
				g.drawLine(center.x + 5, center.y, center.x + 25, center.y);
				g.drawLine(center.x + 15, center.y - 10, center.x + 25, center.y);
				g.drawLine(center.x + 15, center.y + 10, center.x + 25, center.y);
				
				center.y -= 2;
				g.drawLine(center.x + 5, center.y, center.x + 25, center.y);
				g.drawLine(center.x + 15, center.y - 10, center.x + 25, center.y);
				g.drawLine(center.x + 15, center.y + 10, center.x + 25, center.y);
				
			}
			
		}
		
		
		g.setColor(origCol);
	}

	public boolean isGoingMinDirection() {
		return goingMinDirection;
	}

	public void setGoingMinDirection(boolean goingMinDirection) {
		this.goingMinDirection = goingMinDirection;
	}
	
	
	
	
}
